VERSION 5.00
Object = "{648A5603-2C6E-101B-82B6-000000000014}#1.1#0"; "MSCOMM32.OCX"
Begin VB.Form frmAN037 
   Caption         =   "QCI - AN037  (Data Acquisition Using Non-Volatile Memory) "
   ClientHeight    =   5640
   ClientLeft      =   5505
   ClientTop       =   4455
   ClientWidth     =   8460
   LinkTopic       =   "Form1"
   ScaleHeight     =   5640
   ScaleWidth      =   8460
   Begin VB.TextBox txtNumRow 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   4680
      TabIndex        =   7
      Top             =   840
      Width           =   1095
   End
   Begin VB.TextBox txtStartAdr 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   1200
      TabIndex        =   6
      Top             =   840
      Width           =   1095
   End
   Begin VB.CommandButton ClearNVMbttn 
      BackColor       =   &H008080FF&
      Caption         =   "Clear Display"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   6720
      MaskColor       =   &H8000000E&
      TabIndex        =   4
      Top             =   3960
      UseMaskColor    =   -1  'True
      Width           =   1695
   End
   Begin VB.TextBox txtNVM 
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   2535
      Left            =   480
      Locked          =   -1  'True
      MultiLine       =   -1  'True
      ScrollBars      =   2  'Vertical
      TabIndex        =   3
      Top             =   2880
      Width           =   6135
   End
   Begin VB.CommandButton Stop 
      Caption         =   "Stop Device"
      Height          =   495
      Left            =   6960
      TabIndex        =   2
      Top             =   1320
      Width           =   1215
   End
   Begin VB.Timer tmrDelay 
      Interval        =   1
      Left            =   7440
      Top             =   2760
   End
   Begin MSCommLib.MSComm MSComm1 
      Left            =   7320
      Top             =   2040
      _ExtentX        =   1005
      _ExtentY        =   1005
      _Version        =   393216
      DTREnable       =   -1  'True
      StopBits        =   2
   End
   Begin VB.CommandButton Uploadbttn 
      Caption         =   "Upload"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   495
      Left            =   2640
      TabIndex        =   1
      Top             =   1320
      Width           =   1695
   End
   Begin VB.CommandButton cmdExit 
      Caption         =   "Exit"
      Height          =   495
      Left            =   6960
      TabIndex        =   0
      Top             =   240
      Width           =   1215
   End
   Begin VB.Label Label6 
      Caption         =   "Actual Position        (HEX)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000C0&
      Height          =   615
      Left            =   4680
      TabIndex        =   11
      Top             =   2160
      Width           =   1575
   End
   Begin VB.Label Label1 
      Caption         =   "Analog Value          (HEX)"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000C0&
      Height          =   615
      Left            =   2520
      TabIndex        =   10
      Top             =   2160
      Width           =   1575
   End
   Begin VB.Label Label5 
      Caption         =   "Number of Rows to Upload"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   660
      Left            =   4680
      TabIndex        =   9
      Top             =   120
      Width           =   1860
   End
   Begin VB.Label Label4 
      Caption         =   "Start of NV Memory Address"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   660
      Left            =   1080
      TabIndex        =   8
      Top             =   120
      Width           =   1935
   End
   Begin VB.Label Label2 
      Caption         =   "NV Memory Address"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   12
         Charset         =   0
         Weight          =   400
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      ForeColor       =   &H000000C0&
      Height          =   900
      Left            =   480
      TabIndex        =   5
      Top             =   1920
      Width           =   1125
   End
End
Attribute VB_Name = "frmAN037"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit
Dim currentTime As Single
Dim delayTime As Single
Dim strOut As String
Dim strIn As String
Dim strMsg As String
Dim NVMData As String
Dim Reg As Integer
Dim NVMaddr As Integer


Private Sub ClearNVMbttn_Click()
NVMData = ""
txtNVM.Text = ""
txtNumRow.Text = ""
End Sub

Private Sub cmdExit_Click()
  ' close the serial port
   MSComm1.PortOpen = False
   End
End Sub


Private Sub Form_Load()
  '  Setup and open COM Port 1
   MSComm1.CommPort = 1
   MSComm1.Settings = "57600,N,8,2"
   MSComm1.InputLen = 0
   MSComm1.PortOpen = True
   txtStartAdr.Text = "1000"
End Sub

Private Sub Label3_Click()

End Sub

Private Sub Stop_Click()
   
   'Send Stop (STP) command to device
   strOut = "@16 3 0 " & Chr(13)
   MSComm1.Output = strOut
   
   
   ' delay to give device time to respond
    delayTime = currentTime + 4
   Do
      DoEvents      ' needed so that timer will update
                    ' while we are in this loop
   Loop Until (currentTime >= delayTime)
   
   ' Get response from Device
   strIn = MSComm1.Input
      
   ' Display response
   If strIn = "" Then
      strMsg = "Device did not respond"
   Else
      strMsg = "Device Response:  " & strIn + vbCrLf + _
               "# - Successful + Data" + vbCrLf + _
               "* - Successful" + vbCrLf + _
               "! - Not Acknowledge"
   End If
   
   MsgBox (strMsg)
   
End Sub


Private Sub tmrDelay_Timer()
   currentTime = currentTime + 1
End Sub

Private Sub Uploadbttn_Click()
Dim Pass As Integer
Reg = 25    ' NV Memory will load to start of User Register 25
Pass = 1    ' Keep track of NV Mem addr

 

' Check if starting & ending address is entered
If txtStartAdr.Text = "" Or txtNumRow.Text = "" Then
    MsgBox "Need Starting Address and Number of Rows ", vbCritical
    Exit Sub
Else

    ' Start uploading data from NV Memory
    For NVMaddr = CInt(txtStartAdr) To (CInt((CInt(txtNumRow.Text) * 6) + _
                  CInt(txtStartAdr.Text)) - 6) Step 6
    
        ' Send Register Load Multiple (RLM) ; NV -> Reg[25 & 26]
        strOut = "@16 197 2 25 " + CStr(NVMaddr) + " " + Chr(13)
        MSComm1.Output = strOut
   
        ' delay to give device time to respond
        delayTime = currentTime + 3
        Do
            DoEvents        ' needed so that timer will update
                            ' while we are in this loop
        Loop Until (currentTime >= delayTime)

  
        ' Get response from Device
        strIn = MSComm1.Input
   
        ' Able to read from NV Memory -> Data Registers
        If strIn = "" Then
            MsgBox "Device did not response"
            Exit Sub
        Else
   
                ' Loop through all NV memories
                Do
     
                ' Send Read Register (RRG) ; Reg[25]
                strOut = "@16 12 " + CStr(Reg) + " " + Chr(13)
                MSComm1.Output = strOut
   
                ' delay to give device time to respond
                delayTime = currentTime + 2
                Do
                DoEvents        ' needed so that timer will update
                                ' while we are in this loop
                Loop Until (currentTime >= delayTime)

  
                ' Get response from Device
                strIn = MSComm1.Input
        
                If strIn = "" Then
                    MsgBox "Error retrieving data"
                    Exit Sub
                End If
        
                If (Pass Mod 2) = 1 Then
                    'Show NV Memory add plus Data
                    NVMData = NVMData + CStr(NVMaddr) + _
                              vbTab + vbTab + Mid(strIn, 10, 10)
                Else
                    'Don't show NV Memory address
                    NVMData = NVMData + vbTab + Mid(strIn, 10, 10) + vbCrLf
        
                End If
        
                Reg = Reg + 1
                Pass = Pass + 1
                
                Loop Until (Reg > 26)
        
   
            
            'Display data
            txtNVM.Text = NVMData
      
            ' Reset Reg to 25 for next row
            Reg = 25
      
        End If

    Next NVMaddr
     
End If


End Sub
